<?php
require_once 'includes/auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($phone) || empty($password)) {
        header('Location: login.php?error=Please enter both phone and password');
        exit();
    }
    
    if (loginUser($phone, $password)) {
        // Login successful - redirect to chat
        header('Location: chat.php');
        exit();
    } else {
        // Login failed
        header('Location: login.php?error=Invalid phone number or password');
        exit();
    }
} else {
    // Not a POST request
    header('Location: login.php');
    exit();
}
