<style>
  /* Sidebar Styles */
  .sidebar {
    width: 220px;
    background: var(--surface);
    height: 100vh;
    position: fixed;
    left: 0;
    top: 0;
    display: flex;
    flex-direction: column;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
    z-index: 1000;
    overflow-y: auto;
    padding: 0;
  }
  
  .sidebar-brand {
    padding: 1.5rem;
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--accent-orange);
    border-bottom: 1px solid rgba(255,255,255,0.05);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }
  
  .nav {
    flex: 1;
    display: flex;
    flex-direction: column;
    padding: 1rem 0;
    overflow-y: auto;
  }
  
  .nav-item {
    display: flex;
    align-items: center;
    padding: 0.75rem 1.25rem;
    color: var(--muted);
    text-decoration: none;
    transition: all 0.2s;
    white-space: nowrap;
    position: relative;
    width: 100%;
    box-sizing: border-box;
    justify-content: flex-start;
  }
  
  .nav-item:hover {
    background: rgba(255,255,255,0.03);
    color: var(--text);
  }
  
  .nav-item.active {
    background: rgba(255,154,60,0.1);
    color: var(--accent-orange);
    border-left: 3px solid var(--accent-orange);
  }
  
  .nav-item svg {
    margin-right: 12px;
    flex-shrink: 0;
    width: 20px;
    text-align: center;
    flex: 0 0 20px;
  }
  
  .badge {
    margin-left: auto;
    background: var(--accent-orange);
    color: white;
    font-size: 0.7rem;
    padding: 0.2rem 0.5rem;
    border-radius: 10px;
    font-weight: 600;
  }
  
  /* Dropdown Styles */
  .nav-dropdown {
    list-style: none;
    padding: 0;
    margin: 0;
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease;
  }
  
  .nav-dropdown.show {
    max-height: 500px; /* Adjust based on content */
  }
  
  .nav-dropdown .nav-item {
    padding-left: 2.5rem;
    padding-right: 1.25rem;
    font-size: 0.9em;
  }
  
  .nav-dropdown-toggle {
    display: flex;
    justify-content: flex-start;
    align-items: center;
    cursor: pointer;
    width: 100%;
  }
  
  .nav-dropdown-toggle > div {
    display: flex;
    align-items: center;
    flex-grow: 1;
  }
  
  .nav-dropdown-toggle::after {
    content: '▸';
    transition: transform 0.2s;
    margin-left: auto;
    font-size: 0.8em;
    opacity: 0.7;
    padding-left: 1rem;
  }
  
  .nav-dropdown-toggle.active::after {
    transform: rotate(90deg);
  }
  
  /* Ensure main content doesn't get hidden behind fixed sidebar */
  .main {
    margin-left: 250px;
    width: calc(100% - 250px);
    padding: 1.5rem;
  }
  
  @media (max-width: 768px) {
    .sidebar {
      transform: translateX(-100%);
      transition: transform 0.3s ease;
    }
    
    .sidebar.show {
      transform: translateX(0);
    }
    
    .main {
      margin-left: 0;
      width: 100%;
    }
  }
</style>

<aside class="sidebar">
  <div class="sidebar-brand">Voice Data Admin</div>
  <nav class="nav">
    <a href="dashboard.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'dashboard.php' ? 'active' : '' ?>">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
        <polyline points="9 22 9 12 15 12 15 22"></polyline>
      </svg>
      <span>Dashboard</span>
    </a>
    
    <a href="recordings.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'recordings.php' ? 'active' : '' ?>">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
      </svg>
      <span>All Recordings</span>
    </a>
    
    <a href="task_management.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'task_management.php' ? 'active' : '' ?>">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
        <polyline points="14 2 14 8 20 8"></polyline>
        <line x1="16" y1="13" x2="8" y2="13"></line>
        <line x1="16" y1="17" x2="8" y2="17"></line>
        <polyline points="10 9 9 9 8 9"></polyline>
      </svg>
      <span>Tasks</span>
    </a>
    
    <a href="users.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'users.php' ? 'active' : '' ?>">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
        <circle cx="9" cy="7" r="4"></circle>
        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
      </svg>
      <span>Users</span>
      <span class="badge"><?= isset($usersCount) ? $usersCount : '0' ?></span>
    </a>
    
    <a href="settings.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'settings.php' ? 'active' : '' ?>">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <circle cx="12" cy="12" r="3"></circle>
        <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path>
      </svg>
      <span>Settings</span>
    </a>
    
    <a href="change_password.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'change_password.php' ? 'active' : '' ?>">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
      </svg>
      <span>Change Password</span>
    </a>
    
    <a href="logout.php" class="nav-item" style="margin-top: auto;">
      <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
        <polyline points="16 17 21 12 16 7"></polyline>
        <line x1="21" y1="12" x2="9" y2="12"></line>
      </svg>
      <span>Logout</span>
    </a>
  </nav>
</aside>

<script>
// Toggle dropdown menus
document.addEventListener('DOMContentLoaded', function() {
  const dropdownToggles = document.querySelectorAll('.nav-dropdown-toggle');
  
  dropdownToggles.forEach(toggle => {
    toggle.addEventListener('click', function() {
      const dropdown = this.nextElementSibling;
      this.classList.toggle('active');
      dropdown.classList.toggle('show');
    });
    
    // Auto-expand if current page is in this dropdown
    const currentItem = toggle.querySelector('a[href="' + window.location.pathname.split('/').pop() + '"]');
    if (currentItem) {
      toggle.classList.add('active');
      toggle.nextElementSibling.classList.add('show');
    }
  });
  
  // Mobile menu toggle (if needed)
  const menuToggle = document.querySelector('.menu-toggle');
  if (menuToggle) {
    menuToggle.addEventListener('click', function() {
      document.querySelector('.sidebar').classList.toggle('show');
    });
  }
});
</script>
