<?php
session_start();
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/includes/db_connect.php';

// Get counts for any relevant statistics
// $pendingCount = (int)$pdo->query("SELECT COUNT(*) FROM recordings WHERE status='pending'")->fetchColumn();
// $usersCount = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>Task Management - Admin Panel</title>
  <link rel="stylesheet" href="assets/theme.css">
  <style>
    .management-cards {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
      gap: 1.5rem;
      padding: 1.5rem 0;
    }
    .management-card {
      background: white;
      border-radius: 8px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
      padding: 1.5rem;
      transition: transform 0.2s, box-shadow 0.2s;
      text-align: center;
      border: 1px solid #e2e8f0;
    }
    .management-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    .management-card h3 {
      margin: 0 0 1rem;
      color: #2d3748;
    }
    .management-card p {
      color: #4a5568;
      margin-bottom: 1.5rem;
    }
    .btn {
      display: inline-block;
      background: #4a90e2;
      color: white;
      padding: 0.5rem 1.5rem;
      border-radius: 4px;
      text-decoration: none;
      font-weight: 500;
      transition: background-color 0.2s;
    }
    .btn:hover {
      background: #3b82f6;
    }
  </style>
</head>
<body class="dashboard-page">
  <aside class="sidebar">
    <div class="sidebar-brand">Wake Word</div>
    <nav class="nav">
      <a href="dashboard.php" class="nav-item">Dashboard</a>
      <a href="task_management.php" class="nav-item active">Task Management</a>
      <a href="mini_task_manager.php" class="nav-item">Mini Tasks</a>
      <a href="daily_task_tracking.php" class="nav-item">Daily Task Tracking</a>
      <a href="users.php" class="nav-item">Users</a>
      <a href="settings.php" class="nav-item">Settings</a>
    </nav>
  </aside>

  <main class="main">
    <header class="topbar">
      <div class="topbar-left">Task Management</div>
      <div class="topbar-right">Welcome, Admin</div>
    </header>

    <section class="content">
      <div class="management-cards">
        <!-- Category Manager -->
        <div class="management-card">
          <h3>Category Manager</h3>
          <p>Manage and organize task categories for better task organization and filtering.</p>
          <a href="category_manager.php" class="btn">Manage Categories</a>
        </div>

        <!-- Mini Task Manager -->
        <div class="management-card">
          <h3>Mini Task Manager</h3>
          <p>Create and manage mini tasks with instruction bubbles and audio prompts for users.</p>
          <a href="mini_task_manager.php" class="btn">
            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-right: 6px;">
              <path d="M12 20h9"></path>
              <path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"></path>
            </svg>
            Manage Mini Tasks
          </a>
        </div>

        <!-- Daily Task Tracking -->
        <div class="management-card">
          <h3>Daily Task Tracking</h3>
          <p>Review, approve, and manage user recordings and task submissions. Monitor completion rates and user activity.</p>
          <a href="daily_task_tracking.php" class="btn">
            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-right: 6px;">
              <circle cx="12" cy="12" r="10"></circle>
              <polyline points="12 6 12 12 16 14"></polyline>
            </svg>
            Manage Recordings
          </a>
        </div>

        <!-- Bulk Task Upload -->
        <div class="management-card">
          <h3>Bulk Task Upload</h3>
          <p>Upload multiple tasks at once using a CSV file to quickly populate your task list.</p>
          <a href="bulk_task_upload.php" class="btn">
            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-right: 6px;">
              <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
              <polyline points="17 8 12 3 7 8"></polyline>
              <line x1="12" y1="3" x2="12" y2="15"></line>
            </svg>
            Upload Tasks
          </a>
        </div>

        <!-- User Group Management -->
        <div class="management-card">
          <h3>User Group Management</h3>
          <p>Create and manage user groups with specific permissions and access levels.</p>
          <a href="user_groups.php" class="btn">Manage Groups</a>
        </div>
      </div>
    </section>
  </main>
</body>
</html>
