<?php
session_start();
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/includes/db_connect.php';

// Fetch pending recordings (limit 30)
$stmt = $pdo->prepare("SELECT r.*, u.full_name, u.phone, t.title AS task_title FROM recordings r JOIN users u ON u.id=r.user_id LEFT JOIN tasks t ON t.id=r.task_id WHERE r.status='pending' ORDER BY r.created_at ASC LIMIT 50");
$stmt->execute();
$rows = $stmt->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1"/><title>Review Queue</title><link rel="stylesheet" href="assets/theme.css"></head><body class="dashboard-page">
<aside class="sidebar">
  <div class="sidebar-brand">Wake Word</div>
  <nav class="nav">
    <a href="dashboard.php" class="nav-item">Dashboard</a>
    <a href="review_queue.php" class="nav-item active">Review Queue</a>
    <a href="users.php" class="nav-item">Users</a>
    <a href="export.php" class="nav-item">Dataset Export</a>
    <a href="audit_logs.php" class="nav-item">Audit Logs</a>
    <a href="logout.php" class="nav-item">Logout</a>
  </nav>
</aside>
<main class="main">
<header class="topbar"><div class="topbar-left">Review Queue</div><div class="topbar-right"></div></header>
<section class="content">
  <?php if(empty($rows)): ?>
    <div class="placeholder"><p class="muted">No pending recordings.</p></div>
  <?php else: ?>
    <?php foreach($rows as $r): ?>
      <div class="card" style="margin-bottom:12px">
        <div style="display:flex;justify-content:space-between;align-items:center">
          <div><strong><?=htmlspecialchars($r['full_name'])?></strong> &middot; <?=htmlspecialchars($r['phone'])?> <div class="meta"><?=htmlspecialchars($r['task_title'])?></div></div>
          <div class="meta"><?=htmlspecialchars($r['created_at'])?></div>
        </div>
        <div style="margin-top:10px">
          <audio controls src="<?=htmlspecialchars('../'.ltrim($r['filename'],'/'))?>" style="width:100%"></audio>
        </div>
        <form method="post" action="review_action.php" style="margin-top:10px;display:flex;gap:8px">
          <input type="hidden" name="recording_id" value="<?=intval($r['id'])?>">
          <select name="status" required>
            <option value="">-- Review --</option>
            <option value="approved">Approve</option>
            <option value="rejected">Reject</option>
          </select>
          <input name="note" placeholder="Reason (optional)">
          <button class="btn primary" type="submit">Save</button>
        </form>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</section>
</main></body></html>