<?php
session_start();
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/includes/db_connect.php';

$stmt = $pdo->prepare("SELECT a.*, ad.username FROM audit_logs a LEFT JOIN admins ad ON ad.id=a.admin_id ORDER BY a.created_at DESC LIMIT 200");
$stmt->execute();
$logs = $stmt->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1"/><title>Audit Logs</title><link rel="stylesheet" href="assets/theme.css"></head><body class="dashboard-page">
<aside class="sidebar">
  <div class="sidebar-brand">Wake Word</div>
  <nav class="nav">
    <a href="dashboard.php" class="nav-item">Dashboard</a>
    <a href="review_queue.php" class="nav-item">Review Queue</a>
    <a href="users.php" class="nav-item">Users</a>
    <a href="export.php" class="nav-item">Dataset Export</a>
    <a href="audit_logs.php" class="nav-item active">Audit Logs</a>
    <a href="logout.php" class="nav-item">Logout</a>
  </nav>
</aside>
<main class="main"><header class="topbar"><div class="topbar-left">Audit Logs</div></header><section class="content">
  <div class="card">
    <table style="width:100%;border-collapse:collapse">
      <thead><tr><th>Date</th><th>Admin</th><th>Action</th><th>Target</th><th>Details</th></tr></thead>
      <tbody>
        <?php foreach($logs as $l): ?>
          <tr style="border-bottom:1px solid rgba(255,255,255,0.03)">
            <td><?=htmlspecialchars($l['created_at'])?></td>
            <td><?=htmlspecialchars($l['username'])?></td>
            <td><?=htmlspecialchars($l['action'])?></td>
            <td><?=htmlspecialchars($l['target_type'].' #'.$l['target_id'])?></td>
            <td><?=htmlspecialchars($l['details'])?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</section></main></body></html>